<?php
// src/RateLimiter.php

require_once __DIR__ . '/../config.php';

class RateLimiter {
    private $limitsFile;
    private $maxRequests;
    private $windowSeconds;

    public function __construct() {
        $this->limitsFile = RATE_LIMIT_FILE;
        $this->maxRequests = RATE_LIMIT_MAX_REQUESTS;
        $this->windowSeconds = RATE_LIMIT_WINDOW_SECONDS;
    }

    public function isAllowed($userId) {
        $limits = $this->readLimits();
        $currentTime = time();
        $userKey = (string)$userId;

        if (!isset($limits[$userKey])) {
            $limits[$userKey] = [
                'first_request_time' => $currentTime,
                'count' => 0
            ];
        }

        $user_data = $limits[$userKey];
        $time_window = $this->windowSeconds;
        $limit = $this->maxRequests;

        // اگر زمان 12 ساعت گذشته باشد، ریست کن
        if (($currentTime - $user_data['first_request_time']) >= $time_window) {
            $limits[$userKey] = [
                'first_request_time' => $currentTime,
                'count' => 1
            ];
            file_put_contents($this->limitsFile, json_encode($limits, JSON_PRETTY_PRINT));
            return true;
        }

        // اگر تعداد درخواست‌ها کمتر از حد مجاز است
        if ($user_data['count'] < $limit) {
            $limits[$userKey]['count']++;
            file_put_contents($this->limitsFile, json_encode($limits, JSON_PRETTY_PRINT));
            return true;
        }

        // اگر به حد مجاز رسیده است
        $time_left = $time_window - ($currentTime - $user_data['first_request_time']);
        $hours_left = ceil($time_left / 3600);
        return "❌ شما به حداکثر تعداد درخواست (12 عدد) در 12 ساعت رسیده‌اید. لطفاً {$hours_left} ساعت دیگر امتحان کنید.";
    }

    private function readLimits() {
        if (file_exists($this->limitsFile)) {
            $content = file_get_contents($this->limitsFile);
            return json_decode($content, true) ?: [];
        }
        return [];
    }

    private function writeLimits($limits) {
        file_put_contents($this->limitsFile, json_encode($limits, JSON_PRETTY_PRINT));
    }
}