<?php
// src/AdvancedHttpClient.php

class AdvancedHttpClient {
    private $user_agents = [
        'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36',
        'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:89.0) Gecko/20100101 Firefox/89.0',
        'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.1 Safari/605.1.15',
        'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
    ];

    public function get($url, $options = []) {
        $timeout = $options['timeout'] ?? 10;
        $max_retries = $options['max_retries'] ?? 1;
        $headers = $options['headers'] ?? [];

        $userAgent = $this->user_agents[array_rand($this->user_agents)];
        $defaultHeaders = [
            'User-Agent: ' . $userAgent,
            'Accept: application/json',
        ];
        $allHeaders = array_merge($defaultHeaders, $headers);

        $attempts = 0;
        $response = null;
        $httpCode = 0;
        $error = '';

        while ($attempts <= $max_retries) {
            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => $timeout,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false, // فقط در صورت نیاز و اطمینان
                CURLOPT_HTTPHEADER => $allHeaders,
            ]);

            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $error = curl_error($ch);
            curl_close($ch);

            if (!$error && $httpCode === 200) {
                break; // موفقیت
            }

            error_log("cURL attempt $attempts failed for URL: $url. Error: $error, HTTP Code: $httpCode");
            $attempts++;
        }

        if ($error) {
            return ['success' => false, 'error' => $error, 'data' => null];
        }

        if ($httpCode !== 200) {
            return ['success' => false, 'error' => "HTTP Error: $httpCode", 'data' => null];
        }

        return ['success' => true, 'error' => null, 'data' => $response];
    }

    public function post($url, $data, $headers = []) {
        $userAgent = $this->user_agents[array_rand($this->user_agents)];
        $defaultHeaders = [
            'User-Agent: ' . $userAgent,
            'Accept: application/json',
            'Content-Type: application/json',
        ];
        $allHeaders = array_merge($defaultHeaders, $headers);

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_TIMEOUT => 45, // افزایش زمان برای OpenAI
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTPHEADER => $allHeaders,
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);

        if ($error) {
            error_log("cURL POST Error: " . $error);
            return ['success' => false, 'error' => $error, 'data' => null];
        }

        if ($httpCode !== 200 && $httpCode !== 201) {
            error_log("HTTP POST Error: " . $httpCode . " for URL: " . $url . " Response: " . $response);
            return ['success' => false, 'error' => "HTTP Error: $httpCode", 'data' => $response];
        }

        return ['success' => true, 'error' => null, 'data' => $response];
    }
}